#ifndef __NETX51_XC_H
#define __NETX51_XC_H

#include <stdint.h>   /* ISO C99: uint8_t/uint16_t/uint32_t definitions */

/*****************************************************************************/
/* Definitions                                                               */
/*****************************************************************************/

typedef enum NX51_XC_TYPE_Etag {
  NX51_XC_TYPE_RPEC,
  NX51_XC_TYPE_TPEC,
  NX51_XC_TYPE_RPU,
  NX51_XC_TYPE_TPU
} NX51_XC_TYPE_E;


/*****************************************************************************/
/* Function prototypes                                                       */
/*****************************************************************************/
int NX51_XC_Reset( unsigned int uPortNo, void* pvUser );
int NX51_XC_Load( unsigned int uPortNo, NX51_XC_TYPE_E eXcType, const uint32_t* pulXcPrg, void* pvUser );
int NX51_XC_Start( unsigned int uPortNo, void* pvUser );

#endif /* #ifndef __NETX51_XC_H */
